/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.util.Set;
import java.util.Stack;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlCoreTLV
extends JstlBaseTLV {
    private static final String CHOOSE = "choose";
    private static final String WHEN = "when";
    private static final String OTHERWISE = "otherwise";
    private static final String EXPR = "out";
    private static final String SET = "set";
    private static final String IMPORT = "import";
    private static final String URL = "url";
    private static final String REDIRECT = "redirect";
    private static final String PARAM = "param";
    private static final String TEXT = "text";
    private static final String VALUE = "value";
    private static final String DEFAULT = "default";
    private static final String VAR_READER = "varReader";
    private static final String IMPORT_WITH_READER = "import varReader=''";
    private static final String IMPORT_WITHOUT_READER = "import var=''";

    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        return super.validate(1, prefix, uri, page);
    }

    protected DefaultHandler getHandler() {
        return new Handler();
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack chooseDepths = new Stack();
        private Stack chooseHasOtherwise = new Stack();
        private Stack chooseHasWhen = new Stack();
        private Stack urlTags = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            Set expAtts;
            if (ln == null) {
                ln = JstlCoreTLV.this.getLocalPart(qn);
            }
            if (JstlCoreTLV.this.isJspTag(ns, ln, JstlCoreTLV.TEXT)) {
                return;
            }
            if (this.bodyIllegal) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (qn.startsWith(JstlCoreTLV.this.prefix + ":") && (expAtts = (Set)JstlCoreTLV.this.config.get(ln)) != null) {
                for (int i = 0; i < a.getLength(); ++i) {
                    String vMsg;
                    String attName = a.getLocalName(i);
                    if (!expAtts.contains(attName) || (vMsg = JstlCoreTLV.this.validateExpression(ln, attName, a.getValue(i))) == null) continue;
                    JstlCoreTLV.this.fail(vMsg);
                }
            }
            if (qn.startsWith(JstlCoreTLV.this.prefix + ":") && !JstlCoreTLV.this.hasNoInvalidScope(a)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", qn, a.getValue("scope")));
            }
            if (qn.startsWith(JstlCoreTLV.this.prefix + ":") && JstlCoreTLV.this.hasEmptyVar(a)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", qn));
            }
            if (qn.startsWith(JstlCoreTLV.this.prefix + ":") && JstlCoreTLV.this.hasDanglingScope(a)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", qn));
            }
            if (this.chooseChild()) {
                if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.WHEN)) {
                    this.chooseHasWhen.pop();
                    this.chooseHasWhen.push(Boolean.TRUE);
                }
                if (!JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.WHEN) && !JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.OTHERWISE)) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlCoreTLV.this.prefix, JstlCoreTLV.CHOOSE, qn));
                }
                if (((Boolean)this.chooseHasOtherwise.peek()).booleanValue()) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORDER", qn, JstlCoreTLV.this.prefix, JstlCoreTLV.OTHERWISE, JstlCoreTLV.CHOOSE));
                }
                if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.OTHERWISE)) {
                    this.chooseHasOtherwise.pop();
                    this.chooseHasOtherwise.push(Boolean.TRUE);
                }
            }
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.PARAM)) {
                if (this.urlTags.empty() || this.urlTags.peek().equals(JstlCoreTLV.PARAM)) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORPHAN", JstlCoreTLV.PARAM));
                }
                if (!this.urlTags.empty() && this.urlTags.peek().equals(JstlCoreTLV.IMPORT_WITH_READER)) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_PARAM", JstlCoreTLV.this.prefix, JstlCoreTLV.PARAM, JstlCoreTLV.IMPORT, JstlCoreTLV.VAR_READER));
                }
            } else if (!this.urlTags.empty() && this.urlTags.peek().equals(JstlCoreTLV.IMPORT_WITHOUT_READER)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlCoreTLV.this.prefix, JstlCoreTLV.IMPORT, qn));
            }
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.CHOOSE)) {
                this.chooseDepths.push(new Integer(this.depth));
                this.chooseHasWhen.push(Boolean.FALSE);
                this.chooseHasOtherwise.push(Boolean.FALSE);
            }
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.IMPORT)) {
                if (JstlCoreTLV.this.hasAttribute(a, JstlCoreTLV.VAR_READER)) {
                    this.urlTags.push(JstlCoreTLV.IMPORT_WITH_READER);
                } else {
                    this.urlTags.push(JstlCoreTLV.IMPORT_WITHOUT_READER);
                }
            } else if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.PARAM)) {
                this.urlTags.push(JstlCoreTLV.PARAM);
            } else if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.REDIRECT)) {
                this.urlTags.push(JstlCoreTLV.REDIRECT);
            } else if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.URL)) {
                this.urlTags.push(JstlCoreTLV.URL);
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.EXPR)) {
                if (JstlCoreTLV.this.hasAttribute(a, JstlCoreTLV.DEFAULT)) {
                    this.bodyIllegal = true;
                }
            } else if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.SET) && JstlCoreTLV.this.hasAttribute(a, JstlCoreTLV.VALUE)) {
                this.bodyIllegal = true;
            }
            this.lastElementName = qn;
            JstlCoreTLV.this.lastElementId = a.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (!this.urlTags.empty() && this.urlTags.peek().equals(JstlCoreTLV.IMPORT_WITHOUT_READER)) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlCoreTLV.this.prefix + ":" + JstlCoreTLV.IMPORT));
            }
            if (this.chooseChild()) {
                String msg = Resources.getMessage("TLV_ILLEGAL_TEXT_BODY", JstlCoreTLV.this.prefix, JstlCoreTLV.CHOOSE, s.length() < 7 ? s : s.substring(0, 7));
                JstlCoreTLV.this.fail(msg);
            }
        }

        public void endElement(String ns, String ln, String qn) {
            if (JstlCoreTLV.this.isJspTag(ns, ln, JstlCoreTLV.TEXT)) {
                return;
            }
            if (this.bodyNecessary) {
                JstlCoreTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.CHOOSE)) {
                Boolean b = (Boolean)this.chooseHasWhen.pop();
                if (!b.booleanValue()) {
                    JstlCoreTLV.this.fail(Resources.getMessage("TLV_PARENT_WITHOUT_SUBTAG", JstlCoreTLV.CHOOSE, JstlCoreTLV.WHEN));
                }
                this.chooseDepths.pop();
                this.chooseHasOtherwise.pop();
            }
            if (JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.IMPORT) || JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.PARAM) || JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.REDIRECT) || JstlCoreTLV.this.isCoreTag(ns, ln, JstlCoreTLV.URL)) {
                this.urlTags.pop();
            }
            --this.depth;
        }

        private boolean chooseChild() {
            return !this.chooseDepths.empty() && this.depth - 1 == (Integer)this.chooseDepths.peek();
        }
    }
}

