
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was DDMConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/DDM" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# DDM version information
set(DDM_VERSION_MAJOR 0)
set(DDM_VERSION_MINOR 3)
set(DDM_VERSION_PATCH 1)
set(DDM_VERSION 0.3.1)

# 导入 Auth 和 Common 模块的配置文件
include("${CMAKE_CURRENT_LIST_DIR}/CommonConfig.cmake")

# 导出 DDM 相关的信息
set(DDM_FOUND TRUE)
set(DDM_INCLUDE_DIRS "${CMAKE_INSTALL_PREFIX}/include/ddm")
set(DDM_LIBRARIES Auth Common)

# 如果定义了 COMPONENTS 选项，则导出相应的信息
if(DEFINED COMPONENTS)
    foreach(comp ${COMPONENTS})
       if(comp STREQUAL "Common")
            set(DDM_FOUND TRUE)
            set(DDM_COMMON_FOUND TRUE)
            set(DDM_INCLUDE_DIRS ${DDM_INCLUDE_DIRS} ${Common_INCLUDE_DIRS})
            set(DDM_LIBRARIES ${DDM_LIBRARIES} ${Common_LIBRARIES})
        else()
            message(FATAL_ERROR "Unknown component: ${comp}")
        endif()
    endforeach()
endif()

# 如果没有定义 COMPONENTS 选项，则默认导出所有信息
if(NOT DEFINED COMPONENTS OR "${COMPONENTS}" STREQUAL "Common")
    set(DDM_FOUND TRUE)
    set(DDM_INCLUDE_DIRS ${DDM_INCLUDE_DIRS} PARENT_SCOPE)
    set(DDM_LIBRARIES ${DDM_LIBRARIES} PARENT_SCOPE)
endif()

# 检查是否至少找到了一个组件
if(NOT DDM_FOUND)
    message(FATAL_ERROR "None of the requested components were found.")
endif()

# 导出 DDM 的头文件路径和库文件
set(DDM_INCLUDE_DIRS ${DDM_INCLUDE_DIRS} PARENT_SCOPE)
set(DDM_LIBRARIES ${DDM_LIBRARIES} PARENT_SCOPE)
