_sqop() {
    local i cur prev opts cmd
    COMPREPLY=()
    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
        cur="$2"
    else
        cur="${COMP_WORDS[COMP_CWORD]}"
    fi
    prev="$3"
    cmd=""
    opts=""

    for i in "${COMP_WORDS[@]:0:COMP_CWORD}"
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="sqop"
                ;;
            sqop,armor)
                cmd="sqop__armor"
                ;;
            sqop,certify-userid)
                cmd="sqop__certify__userid"
                ;;
            sqop,change-key-password)
                cmd="sqop__change__key__password"
                ;;
            sqop,dearmor)
                cmd="sqop__dearmor"
                ;;
            sqop,decrypt)
                cmd="sqop__decrypt"
                ;;
            sqop,encrypt)
                cmd="sqop__encrypt"
                ;;
            sqop,extract-cert)
                cmd="sqop__extract__cert"
                ;;
            sqop,generate-key)
                cmd="sqop__generate__key"
                ;;
            sqop,help)
                cmd="sqop__help"
                ;;
            sqop,inline-detach)
                cmd="sqop__inline__detach"
                ;;
            sqop,inline-sign)
                cmd="sqop__inline__sign"
                ;;
            sqop,inline-verify)
                cmd="sqop__inline__verify"
                ;;
            sqop,list-profiles)
                cmd="sqop__list__profiles"
                ;;
            sqop,merge-certs)
                cmd="sqop__merge__certs"
                ;;
            sqop,revoke-key)
                cmd="sqop__revoke__key"
                ;;
            sqop,sign)
                cmd="sqop__sign"
                ;;
            sqop,update-key)
                cmd="sqop__update__key"
                ;;
            sqop,validate-userid)
                cmd="sqop__validate__userid"
                ;;
            sqop,verify)
                cmd="sqop__verify"
                ;;
            sqop,version)
                cmd="sqop__version"
                ;;
            sqop__help,armor)
                cmd="sqop__help__armor"
                ;;
            sqop__help,certify-userid)
                cmd="sqop__help__certify__userid"
                ;;
            sqop__help,change-key-password)
                cmd="sqop__help__change__key__password"
                ;;
            sqop__help,dearmor)
                cmd="sqop__help__dearmor"
                ;;
            sqop__help,decrypt)
                cmd="sqop__help__decrypt"
                ;;
            sqop__help,encrypt)
                cmd="sqop__help__encrypt"
                ;;
            sqop__help,extract-cert)
                cmd="sqop__help__extract__cert"
                ;;
            sqop__help,generate-key)
                cmd="sqop__help__generate__key"
                ;;
            sqop__help,help)
                cmd="sqop__help__help"
                ;;
            sqop__help,inline-detach)
                cmd="sqop__help__inline__detach"
                ;;
            sqop__help,inline-sign)
                cmd="sqop__help__inline__sign"
                ;;
            sqop__help,inline-verify)
                cmd="sqop__help__inline__verify"
                ;;
            sqop__help,list-profiles)
                cmd="sqop__help__list__profiles"
                ;;
            sqop__help,merge-certs)
                cmd="sqop__help__merge__certs"
                ;;
            sqop__help,revoke-key)
                cmd="sqop__help__revoke__key"
                ;;
            sqop__help,sign)
                cmd="sqop__help__sign"
                ;;
            sqop__help,update-key)
                cmd="sqop__help__update__key"
                ;;
            sqop__help,validate-userid)
                cmd="sqop__help__validate__userid"
                ;;
            sqop__help,verify)
                cmd="sqop__help__verify"
                ;;
            sqop__help,version)
                cmd="sqop__help__version"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        sqop)
            opts="-h --debug --help version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__armor)
            opts="-h --label --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --label)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__certify__userid)
            opts="-h --no-armor --userid --with-key-password --no-require-self-sig --debug --help [KEYS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --userid)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__change__key__password)
            opts="-h --no-armor --new-key-password --old-key-password --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --new-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --old-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__dearmor)
            opts="-h --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__decrypt)
            opts="-h --session-key-out --with-session-key --with-password --verifications-out --verify-with --verify-not-before --verify-not-after --with-key-password --debug --help [KEYS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --session-key-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-session-key)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verifications-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verify-with)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verify-not-before)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verify-not-after)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__encrypt)
            opts="-h --no-armor --profile --as --with-password --sign-with --with-key-password --session-key-out --debug --help [CERTS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --profile)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --as)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --sign-with)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --session-key-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__extract__cert)
            opts="-h --no-armor --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__generate__key)
            opts="-h --no-armor --profile --signing-only --with-key-password --debug --help [USERIDS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --profile)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help)
            opts="version verify inline-verify list-profiles generate-key change-key-password revoke-key extract-cert update-key merge-certs certify-userid validate-userid sign encrypt decrypt armor dearmor inline-detach inline-sign help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__armor)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__certify__userid)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__change__key__password)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__dearmor)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__decrypt)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__encrypt)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__extract__cert)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__generate__key)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__inline__detach)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__inline__sign)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__inline__verify)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__list__profiles)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__merge__certs)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__revoke__key)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__sign)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__update__key)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__validate__userid)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__verify)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__help__version)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__inline__detach)
            opts="-h --no-armor --signatures-out --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --signatures-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__inline__sign)
            opts="-h --no-armor --as --with-key-password --debug --help [KEYS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --as)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__inline__verify)
            opts="-h --not-before --not-after --verifications-out --debug --help [CERTS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --not-before)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --not-after)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --verifications-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__list__profiles)
            opts="-h --debug --help <SUBCOMMAND>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__merge__certs)
            opts="-h --no-armor --debug --help [CERTS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__revoke__key)
            opts="-h --no-armor --with-key-password --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__sign)
            opts="-h --no-armor --as --micalg-out --with-key-password --debug --help [KEYS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --as)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --micalg-out)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__update__key)
            opts="-h --no-armor --signing-only --no-added-capabilities --with-key-password --merge-certs --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --with-key-password)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --merge-certs)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__validate__userid)
            opts="-h --addr-spec-only --validate-at --debug --help <USERID> <CERTS>..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --validate-at)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__verify)
            opts="-h --not-before --not-after --debug --help <SIGNATURES> [CERTS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --not-before)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --not-after)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        sqop__version)
            opts="-h --backend --extended --sop-spec --sopv --debug --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _sqop -o nosort -o bashdefault -o default sqop
else
    complete -F _sqop -o bashdefault -o default sqop
fi
