%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in PKIXCMP-2023.

-module('PKIXCMP-2023').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("PKIXCMP-2023.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'PKIXCMP-2023'},
            {options,[{i,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_CMPCertificate/2,
enc_PKIMessage/2,
enc_PKIMessages/2,
enc_PKIHeader/2,
enc_PKIFreeText/2,
enc_PKIBody/2,
enc_PKIProtection/2,
enc_ProtectedPart/2,
enc_PBMParameter/2,
enc_DHBMParameter/2,
enc_KemBMParameter/2,
enc_PKIStatus/2,
enc_PKIFailureInfo/2,
enc_PKIStatusInfo/2,
enc_OOBCert/2,
enc_OOBCertHash/2,
enc_POPODecKeyChallContent/2,
enc_Challenge/2,
enc_Rand/2,
enc_POPODecKeyRespContent/2,
enc_CertRepMessage/2,
enc_CertResponse/2,
enc_CertifiedKeyPair/2,
enc_CertOrEncCert/2,
enc_KeyRecRepContent/2,
enc_RevReqContent/2,
enc_RevDetails/2,
enc_RevRepContent/2,
enc_CAKeyUpdAnnContent/2,
enc_CAKeyUpdContent/2,
enc_CertAnnContent/2,
enc_RevAnnContent/2,
enc_CRLAnnContent/2,
enc_PKIConfirmContent/2,
enc_NestedMessageContent/2,
enc_CertReqTemplateContent/2,
enc_AttributeTypeAndValue/2,
enc_AltCertTemplate/2,
enc_AlgIdCtrl/2,
enc_RsaKeyLenCtrl/2,
enc_RootCaKeyUpdateContent/2,
enc_CRLSource/2,
enc_CRLStatus/2,
enc_KemCiphertextInfo/2,
enc_KemOtherInfo/2,
enc_InfoTypeAndValue/2,
enc_GenMsgContent/2,
enc_GenRepContent/2,
enc_ErrorMsgContent/2,
enc_CertConfirmContent/2,
enc_CertStatus/2,
enc_PollReqContent/2,
enc_PollRepContent/2
]).

-export([
dec_CMPCertificate/2,
dec_PKIMessage/2,
dec_PKIMessages/2,
dec_PKIHeader/2,
dec_PKIFreeText/2,
dec_PKIBody/2,
dec_PKIProtection/2,
dec_ProtectedPart/2,
dec_PBMParameter/2,
dec_DHBMParameter/2,
dec_KemBMParameter/2,
dec_PKIStatus/2,
dec_PKIFailureInfo/2,
dec_PKIStatusInfo/2,
dec_OOBCert/2,
dec_OOBCertHash/2,
dec_POPODecKeyChallContent/2,
dec_Challenge/2,
dec_Rand/2,
dec_POPODecKeyRespContent/2,
dec_CertRepMessage/2,
dec_CertResponse/2,
dec_CertifiedKeyPair/2,
dec_CertOrEncCert/2,
dec_KeyRecRepContent/2,
dec_RevReqContent/2,
dec_RevDetails/2,
dec_RevRepContent/2,
dec_CAKeyUpdAnnContent/2,
dec_CAKeyUpdContent/2,
dec_CertAnnContent/2,
dec_RevAnnContent/2,
dec_CRLAnnContent/2,
dec_PKIConfirmContent/2,
dec_NestedMessageContent/2,
dec_CertReqTemplateContent/2,
dec_AttributeTypeAndValue/2,
dec_AltCertTemplate/2,
dec_AlgIdCtrl/2,
dec_RsaKeyLenCtrl/2,
dec_RootCaKeyUpdateContent/2,
dec_CRLSource/2,
dec_CRLStatus/2,
dec_KemCiphertextInfo/2,
dec_KemOtherInfo/2,
dec_InfoTypeAndValue/2,
dec_GenMsgContent/2,
dec_GenRepContent/2,
dec_ErrorMsgContent/2,
dec_CertConfirmContent/2,
dec_CertStatus/2,
dec_PollReqContent/2,
dec_PollRepContent/2
]).

-export([
'enc_regCtrl-altCertTemplate'/3,
'enc_regCtrl-algId'/3,
'enc_regCtrl-rsaKeyLen'/3
]).

-export([
'dec_regCtrl-altCertTemplate'/3,
'dec_regCtrl-algId'/3,
'dec_regCtrl-rsaKeyLen'/3
]).

-export([
getenc_ExpandedRegControlSet/1,
getenc_SupportedInfoSet/1,
getenc_internal_object_set_argument_8/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_2/1,
getenc_internal_object_set_argument_18/1,
getenc_internal_object_set_argument_16/1,
getenc_internal_object_set_argument_14/1,
getenc_internal_object_set_argument_12/1,
getenc_internal_object_set_argument_10/1,
getenc_internal_object_set_argument_29/1,
getenc_internal_object_set_argument_27/1,
getenc_internal_object_set_argument_25/1,
getenc_internal_object_set_argument_24/1,
getenc_internal_object_set_argument_22/1,
getenc_internal_object_set_argument_20/1
]).

-export([
getdec_ExpandedRegControlSet/1,
getdec_SupportedInfoSet/1,
getdec_internal_object_set_argument_8/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_2/1,
getdec_internal_object_set_argument_18/1,
getdec_internal_object_set_argument_16/1,
getdec_internal_object_set_argument_14/1,
getdec_internal_object_set_argument_12/1,
getdec_internal_object_set_argument_10/1,
getdec_internal_object_set_argument_29/1,
getdec_internal_object_set_argument_27/1,
getdec_internal_object_set_argument_25/1,
getdec_internal_object_set_argument_24/1,
getdec_internal_object_set_argument_22/1,
getdec_internal_object_set_argument_20/1
]).

-export([
'id-PasswordBasedMac'/0,
'id-DHBasedMac'/0,
'id-KemBasedMac'/0,
'id-regCtrl-altCertTemplate'/0,
'id-regCtrl-algId'/0,
'id-regCtrl-rsaKeyLen'/0,
'id-kp-cmKGA'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('CMPCertificate', Data) -> enc_CMPCertificate(Data);
encode_disp('PKIMessage', Data) -> enc_PKIMessage(Data);
encode_disp('PKIMessages', Data) -> enc_PKIMessages(Data);
encode_disp('PKIHeader', Data) -> enc_PKIHeader(Data);
encode_disp('PKIFreeText', Data) -> enc_PKIFreeText(Data);
encode_disp('PKIBody', Data) -> enc_PKIBody(Data);
encode_disp('PKIProtection', Data) -> enc_PKIProtection(Data);
encode_disp('ProtectedPart', Data) -> enc_ProtectedPart(Data);
encode_disp('PBMParameter', Data) -> enc_PBMParameter(Data);
encode_disp('DHBMParameter', Data) -> enc_DHBMParameter(Data);
encode_disp('KemBMParameter', Data) -> enc_KemBMParameter(Data);
encode_disp('PKIStatus', Data) -> enc_PKIStatus(Data);
encode_disp('PKIFailureInfo', Data) -> enc_PKIFailureInfo(Data);
encode_disp('PKIStatusInfo', Data) -> enc_PKIStatusInfo(Data);
encode_disp('OOBCert', Data) -> enc_OOBCert(Data);
encode_disp('OOBCertHash', Data) -> enc_OOBCertHash(Data);
encode_disp('POPODecKeyChallContent', Data) -> enc_POPODecKeyChallContent(Data);
encode_disp('Challenge', Data) -> enc_Challenge(Data);
encode_disp('Rand', Data) -> enc_Rand(Data);
encode_disp('POPODecKeyRespContent', Data) -> enc_POPODecKeyRespContent(Data);
encode_disp('CertRepMessage', Data) -> enc_CertRepMessage(Data);
encode_disp('CertResponse', Data) -> enc_CertResponse(Data);
encode_disp('CertifiedKeyPair', Data) -> enc_CertifiedKeyPair(Data);
encode_disp('CertOrEncCert', Data) -> enc_CertOrEncCert(Data);
encode_disp('KeyRecRepContent', Data) -> enc_KeyRecRepContent(Data);
encode_disp('RevReqContent', Data) -> enc_RevReqContent(Data);
encode_disp('RevDetails', Data) -> enc_RevDetails(Data);
encode_disp('RevRepContent', Data) -> enc_RevRepContent(Data);
encode_disp('CAKeyUpdAnnContent', Data) -> enc_CAKeyUpdAnnContent(Data);
encode_disp('CAKeyUpdContent', Data) -> enc_CAKeyUpdContent(Data);
encode_disp('CertAnnContent', Data) -> enc_CertAnnContent(Data);
encode_disp('RevAnnContent', Data) -> enc_RevAnnContent(Data);
encode_disp('CRLAnnContent', Data) -> enc_CRLAnnContent(Data);
encode_disp('PKIConfirmContent', Data) -> enc_PKIConfirmContent(Data);
encode_disp('NestedMessageContent', Data) -> enc_NestedMessageContent(Data);
encode_disp('CertReqTemplateContent', Data) -> enc_CertReqTemplateContent(Data);
encode_disp('AttributeTypeAndValue', Data) -> enc_AttributeTypeAndValue(Data);
encode_disp('AltCertTemplate', Data) -> enc_AltCertTemplate(Data);
encode_disp('AlgIdCtrl', Data) -> enc_AlgIdCtrl(Data);
encode_disp('RsaKeyLenCtrl', Data) -> enc_RsaKeyLenCtrl(Data);
encode_disp('RootCaKeyUpdateContent', Data) -> enc_RootCaKeyUpdateContent(Data);
encode_disp('CRLSource', Data) -> enc_CRLSource(Data);
encode_disp('CRLStatus', Data) -> enc_CRLStatus(Data);
encode_disp('KemCiphertextInfo', Data) -> enc_KemCiphertextInfo(Data);
encode_disp('KemOtherInfo', Data) -> enc_KemOtherInfo(Data);
encode_disp('InfoTypeAndValue', Data) -> enc_InfoTypeAndValue(Data);
encode_disp('GenMsgContent', Data) -> enc_GenMsgContent(Data);
encode_disp('GenRepContent', Data) -> enc_GenRepContent(Data);
encode_disp('ErrorMsgContent', Data) -> enc_ErrorMsgContent(Data);
encode_disp('CertConfirmContent', Data) -> enc_CertConfirmContent(Data);
encode_disp('CertStatus', Data) -> enc_CertStatus(Data);
encode_disp('PollReqContent', Data) -> enc_PollReqContent(Data);
encode_disp('PollRepContent', Data) -> enc_PollRepContent(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('CMPCertificate', Data) -> dec_CMPCertificate(Data);
decode_disp('PKIMessage', Data) -> dec_PKIMessage(Data);
decode_disp('PKIMessages', Data) -> dec_PKIMessages(Data);
decode_disp('PKIHeader', Data) -> dec_PKIHeader(Data);
decode_disp('PKIFreeText', Data) -> dec_PKIFreeText(Data);
decode_disp('PKIBody', Data) -> dec_PKIBody(Data);
decode_disp('PKIProtection', Data) -> dec_PKIProtection(Data);
decode_disp('ProtectedPart', Data) -> dec_ProtectedPart(Data);
decode_disp('PBMParameter', Data) -> dec_PBMParameter(Data);
decode_disp('DHBMParameter', Data) -> dec_DHBMParameter(Data);
decode_disp('KemBMParameter', Data) -> dec_KemBMParameter(Data);
decode_disp('PKIStatus', Data) -> dec_PKIStatus(Data);
decode_disp('PKIFailureInfo', Data) -> dec_PKIFailureInfo(Data);
decode_disp('PKIStatusInfo', Data) -> dec_PKIStatusInfo(Data);
decode_disp('OOBCert', Data) -> dec_OOBCert(Data);
decode_disp('OOBCertHash', Data) -> dec_OOBCertHash(Data);
decode_disp('POPODecKeyChallContent', Data) -> dec_POPODecKeyChallContent(Data);
decode_disp('Challenge', Data) -> dec_Challenge(Data);
decode_disp('Rand', Data) -> dec_Rand(Data);
decode_disp('POPODecKeyRespContent', Data) -> dec_POPODecKeyRespContent(Data);
decode_disp('CertRepMessage', Data) -> dec_CertRepMessage(Data);
decode_disp('CertResponse', Data) -> dec_CertResponse(Data);
decode_disp('CertifiedKeyPair', Data) -> dec_CertifiedKeyPair(Data);
decode_disp('CertOrEncCert', Data) -> dec_CertOrEncCert(Data);
decode_disp('KeyRecRepContent', Data) -> dec_KeyRecRepContent(Data);
decode_disp('RevReqContent', Data) -> dec_RevReqContent(Data);
decode_disp('RevDetails', Data) -> dec_RevDetails(Data);
decode_disp('RevRepContent', Data) -> dec_RevRepContent(Data);
decode_disp('CAKeyUpdAnnContent', Data) -> dec_CAKeyUpdAnnContent(Data);
decode_disp('CAKeyUpdContent', Data) -> dec_CAKeyUpdContent(Data);
decode_disp('CertAnnContent', Data) -> dec_CertAnnContent(Data);
decode_disp('RevAnnContent', Data) -> dec_RevAnnContent(Data);
decode_disp('CRLAnnContent', Data) -> dec_CRLAnnContent(Data);
decode_disp('PKIConfirmContent', Data) -> dec_PKIConfirmContent(Data);
decode_disp('NestedMessageContent', Data) -> dec_NestedMessageContent(Data);
decode_disp('CertReqTemplateContent', Data) -> dec_CertReqTemplateContent(Data);
decode_disp('AttributeTypeAndValue', Data) -> dec_AttributeTypeAndValue(Data);
decode_disp('AltCertTemplate', Data) -> dec_AltCertTemplate(Data);
decode_disp('AlgIdCtrl', Data) -> dec_AlgIdCtrl(Data);
decode_disp('RsaKeyLenCtrl', Data) -> dec_RsaKeyLenCtrl(Data);
decode_disp('RootCaKeyUpdateContent', Data) -> dec_RootCaKeyUpdateContent(Data);
decode_disp('CRLSource', Data) -> dec_CRLSource(Data);
decode_disp('CRLStatus', Data) -> dec_CRLStatus(Data);
decode_disp('KemCiphertextInfo', Data) -> dec_KemCiphertextInfo(Data);
decode_disp('KemOtherInfo', Data) -> dec_KemOtherInfo(Data);
decode_disp('InfoTypeAndValue', Data) -> dec_InfoTypeAndValue(Data);
decode_disp('GenMsgContent', Data) -> dec_GenMsgContent(Data);
decode_disp('GenRepContent', Data) -> dec_GenRepContent(Data);
decode_disp('ErrorMsgContent', Data) -> dec_ErrorMsgContent(Data);
decode_disp('CertConfirmContent', Data) -> dec_CertConfirmContent(Data);
decode_disp('CertStatus', Data) -> dec_CertStatus(Data);
decode_disp('PollReqContent', Data) -> dec_PollReqContent(Data);
decode_disp('PollRepContent', Data) -> dec_PollRepContent(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  CMPCertificate
%%================================
enc_CMPCertificate(Val) ->
    enc_CMPCertificate(Val, []).

enc_CMPCertificate(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      x509v3PKCert ->
         'PKIX1Explicit-2009':'enc_Certificate'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CMPCertificate(Tlv) ->
   dec_CMPCertificate(Tlv, []).

dec_CMPCertificate(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'x509v3PKCert'
    {16, V1} -> 
        {x509v3PKCert, 'PKIX1Explicit-2009':'dec_Certificate'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  PKIMessage
%%================================
enc_PKIMessage(Val) ->
    enc_PKIMessage(Val, [<<48>>]).

enc_PKIMessage(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute header(1)   External PKIXCMP-2023:PKIHeader
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIHeader'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute body(2)   External PKIXCMP-2023:PKIBody
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PKIBody'(Cindex2, []),

%%-------------------------------------------------
%% attribute protection(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex3, [<<3>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute extraCerts(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIMessage_extraCerts'(Cindex4, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIMessage_extraCerts
%%================================
enc_PKIMessage_extraCerts(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIMessage_extraCerts_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIMessage_extraCerts_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIMessage_extraCerts_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CMPCertificate'(H, []),
   'enc_PKIMessage_extraCerts_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIMessage(Tlv) ->
   dec_PKIMessage(Tlv, [16]).

dec_PKIMessage(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute header(1)   External PKIXCMP-2023:PKIHeader
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIHeader'(V1, [16]),

%%-------------------------------------------------
%% attribute body(2)   External PKIXCMP-2023:PKIBody
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PKIBody'(V2, []),

%%-------------------------------------------------
%% attribute protection(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {decode_native_bit_string(V3, [3]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute extraCerts(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131073,V4}|TempTlv5] ->
    {'dec_PKIMessage_extraCerts'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PKIMessage',Term1,Term2,Term3,Term4},
Res1.
'dec_PKIMessage_extraCerts'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CMPCertificate'(V1, []) || V1 <- Tlv1].




%%================================
%%  PKIMessages
%%================================
enc_PKIMessages(Val) ->
    enc_PKIMessages(Val, [<<48>>]).

enc_PKIMessages(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PKIMessages_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIMessages_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIMessages_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PKIMessage'(H, [<<48>>]),
   'enc_PKIMessages_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIMessages(Tlv) ->
   dec_PKIMessages(Tlv, [16]).

dec_PKIMessages(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PKIMessage'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PKIHeader
%%================================
enc_PKIHeader(Val) ->
    enc_PKIHeader(Val, [<<48>>]).

enc_PKIHeader(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10,Cindex11,Cindex12} = Val,

%%-------------------------------------------------
%% attribute pvno(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{cmp1999,1},{cmp2000,2},{cmp2021,3}], [<<2>>]),

%%-------------------------------------------------
%% attribute sender(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, []),

%%-------------------------------------------------
%% attribute recipient(3)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex3, []),

%%-------------------------------------------------
%% attribute messageTime(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<24>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute protectionAlg(5) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIHeader_protectionAlg'(Cindex5, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute senderKID(6) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex6, [<<4>>,<<162>>])
       end,

%%-------------------------------------------------
%% attribute recipKID(7) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex7, [<<4>>,<<163>>])
       end,

%%-------------------------------------------------
%% attribute transactionID(8) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex8, [<<4>>,<<164>>])
       end,

%%-------------------------------------------------
%% attribute senderNonce(9) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex9, [<<4>>,<<165>>])
       end,

%%-------------------------------------------------
%% attribute recipNonce(10) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex10, [<<4>>,<<166>>])
       end,

%%-------------------------------------------------
%% attribute freeText(11)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
   {EncBytes11,EncLen11} =  case Cindex11 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIFreeText'(Cindex11, [<<48>>,<<167>>])
       end,

%%-------------------------------------------------
%% attribute generalInfo(12) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes12,EncLen12} =  case Cindex12 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIHeader_generalInfo'(Cindex12, [<<48>>,<<168>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10, EncBytes11, EncBytes12],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10 + EncLen11 + EncLen12,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIHeader_protectionAlg
%%================================
enc_PKIHeader_protectionAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PKIHeader_generalInfo
%%================================
enc_PKIHeader_generalInfo(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PKIHeader_generalInfo_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIHeader_generalInfo_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIHeader_generalInfo_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_InfoTypeAndValue'(H, [<<48>>]),
   'enc_PKIHeader_generalInfo_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIHeader(Tlv) ->
   dec_PKIHeader(Tlv, [16]).

dec_PKIHeader(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pvno(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{cmp1999,1},{cmp2000,2},{cmp2021,3}])
end
,

%%-------------------------------------------------
%% attribute sender(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit-2009':'dec_GeneralName'(V2, []),

%%-------------------------------------------------
%% attribute recipient(3)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'PKIX1Implicit-2009':'dec_GeneralName'(V3, []),

%%-------------------------------------------------
%% attribute messageTime(4) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {begin
binary_to_list(decode_restricted_string(V4, [24]))
end
, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute protectionAlg(5) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131073,V5}|TempTlv6] ->
    {'dec_PKIHeader_protectionAlg'(V5, [16]), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute senderKID(6) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131074,V6}|TempTlv7] ->
    {decode_octet_string(V6, [4]), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute recipKID(7) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131075,V7}|TempTlv8] ->
    {decode_octet_string(V7, [4]), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute transactionID(8) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131076,V8}|TempTlv9] ->
    {decode_octet_string(V8, [4]), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute senderNonce(9) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131077,V9}|TempTlv10] ->
    {decode_octet_string(V9, [4]), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute recipNonce(10) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131078,V10}|TempTlv11] ->
    {decode_octet_string(V10, [4]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

%%-------------------------------------------------
%% attribute freeText(11)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
{Term11,Tlv12} = case Tlv11 of
[{131079,V11}|TempTlv12] ->
    {'dec_PKIFreeText'(V11, [16]), TempTlv12};
    _ ->
        { asn1_NOVALUE, Tlv11}
end,

%%-------------------------------------------------
%% attribute generalInfo(12) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term12,Tlv13} = case Tlv12 of
[{131080,V12}|TempTlv13] ->
    {'dec_PKIHeader_generalInfo'(V12, [16]), TempTlv13};
    _ ->
        { asn1_NOVALUE, Tlv12}
end,

case Tlv13 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv13}}}) % extra fields not allowed
end,
Res1 = {'PKIHeader',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10,Term11,Term12},
Res1.
'dec_PKIHeader_protectionAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PKIHeader_protectionAlg',Term1,Term2},
Res1.
'dec_PKIHeader_generalInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_InfoTypeAndValue'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PKIFreeText
%%================================
enc_PKIFreeText(Val) ->
    enc_PKIFreeText(Val, [<<48>>]).

enc_PKIFreeText(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PKIFreeText_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PKIFreeText_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PKIFreeText_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_UTF8_string(H, [<<12>>]),
   'enc_PKIFreeText_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PKIFreeText(Tlv) ->
   dec_PKIFreeText(Tlv, [16]).

dec_PKIFreeText(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_UTF8_string(V1, [12]) || V1 <- Tlv1].




%%================================
%%  PKIBody
%%================================
enc_PKIBody(Val) ->
    enc_PKIBody(Val, []).

enc_PKIBody(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ir ->
         'PKIXCRMF-2009':'enc_CertReqMessages'(element(2,Val), [<<48>>,<<160>>]);
      ip ->
         'enc_CertRepMessage'(element(2,Val), [<<48>>,<<161>>]);
      cr ->
         'PKIXCRMF-2009':'enc_CertReqMessages'(element(2,Val), [<<48>>,<<162>>]);
      cp ->
         'enc_CertRepMessage'(element(2,Val), [<<48>>,<<163>>]);
      p10cr ->
         'PKCS-10':'enc_CertificationRequest'(element(2,Val), [<<48>>,<<164>>]);
      popdecc ->
         'enc_POPODecKeyChallContent'(element(2,Val), [<<48>>,<<165>>]);
      popdecr ->
         'enc_POPODecKeyRespContent'(element(2,Val), [<<48>>,<<166>>]);
      kur ->
         'PKIXCRMF-2009':'enc_CertReqMessages'(element(2,Val), [<<48>>,<<167>>]);
      kup ->
         'enc_CertRepMessage'(element(2,Val), [<<48>>,<<168>>]);
      krr ->
         'PKIXCRMF-2009':'enc_CertReqMessages'(element(2,Val), [<<48>>,<<169>>]);
      krp ->
         'enc_KeyRecRepContent'(element(2,Val), [<<48>>,<<170>>]);
      rr ->
         'enc_RevReqContent'(element(2,Val), [<<48>>,<<171>>]);
      rp ->
         'enc_RevRepContent'(element(2,Val), [<<48>>,<<172>>]);
      ccr ->
         'PKIXCRMF-2009':'enc_CertReqMessages'(element(2,Val), [<<48>>,<<173>>]);
      ccp ->
         'enc_CertRepMessage'(element(2,Val), [<<48>>,<<174>>]);
      ckuann ->
         'enc_CAKeyUpdContent'(element(2,Val), [<<175>>]);
      cann ->
         'enc_CertAnnContent'(element(2,Val), [<<176>>]);
      rann ->
         'enc_RevAnnContent'(element(2,Val), [<<48>>,<<177>>]);
      crlann ->
         'enc_CRLAnnContent'(element(2,Val), [<<48>>,<<178>>]);
      pkiconf ->
         encode_null(element(2,Val), [<<5>>,<<179>>]);
      nested ->
         'enc_NestedMessageContent'(element(2,Val), [<<48>>,<<180>>]);
      genm ->
         'enc_GenMsgContent'(element(2,Val), [<<48>>,<<181>>]);
      genp ->
         'enc_GenRepContent'(element(2,Val), [<<48>>,<<182>>]);
      error ->
         'enc_ErrorMsgContent'(element(2,Val), [<<48>>,<<183>>]);
      certConf ->
         'enc_CertConfirmContent'(element(2,Val), [<<48>>,<<184>>]);
      pollReq ->
         'enc_PollReqContent'(element(2,Val), [<<48>>,<<185>>]);
      pollRep ->
         'enc_PollRepContent'(element(2,Val), [<<48>>,<<186>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_PKIBody(Tlv) ->
   dec_PKIBody(Tlv, []).

dec_PKIBody(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ir'
    {131072, V1} -> 
        {ir, 'PKIXCRMF-2009':'dec_CertReqMessages'(V1, [16])};


%% 'ip'
    {131073, V1} -> 
        {ip, 'dec_CertRepMessage'(V1, [16])};


%% 'cr'
    {131074, V1} -> 
        {cr, 'PKIXCRMF-2009':'dec_CertReqMessages'(V1, [16])};


%% 'cp'
    {131075, V1} -> 
        {cp, 'dec_CertRepMessage'(V1, [16])};


%% 'p10cr'
    {131076, V1} -> 
        {p10cr, 'PKCS-10':'dec_CertificationRequest'(V1, [16])};


%% 'popdecc'
    {131077, V1} -> 
        {popdecc, 'dec_POPODecKeyChallContent'(V1, [16])};


%% 'popdecr'
    {131078, V1} -> 
        {popdecr, 'dec_POPODecKeyRespContent'(V1, [16])};


%% 'kur'
    {131079, V1} -> 
        {kur, 'PKIXCRMF-2009':'dec_CertReqMessages'(V1, [16])};


%% 'kup'
    {131080, V1} -> 
        {kup, 'dec_CertRepMessage'(V1, [16])};


%% 'krr'
    {131081, V1} -> 
        {krr, 'PKIXCRMF-2009':'dec_CertReqMessages'(V1, [16])};


%% 'krp'
    {131082, V1} -> 
        {krp, 'dec_KeyRecRepContent'(V1, [16])};


%% 'rr'
    {131083, V1} -> 
        {rr, 'dec_RevReqContent'(V1, [16])};


%% 'rp'
    {131084, V1} -> 
        {rp, 'dec_RevRepContent'(V1, [16])};


%% 'ccr'
    {131085, V1} -> 
        {ccr, 'PKIXCRMF-2009':'dec_CertReqMessages'(V1, [16])};


%% 'ccp'
    {131086, V1} -> 
        {ccp, 'dec_CertRepMessage'(V1, [16])};


%% 'ckuann'
    {131087, V1} -> 
        {ckuann, 'dec_CAKeyUpdContent'(V1, [])};


%% 'cann'
    {131088, V1} -> 
        {cann, 'dec_CertAnnContent'(V1, [])};


%% 'rann'
    {131089, V1} -> 
        {rann, 'dec_RevAnnContent'(V1, [16])};


%% 'crlann'
    {131090, V1} -> 
        {crlann, 'dec_CRLAnnContent'(V1, [16])};


%% 'pkiconf'
    {131091, V1} -> 
        {pkiconf, decode_null(V1, [5])};


%% 'nested'
    {131092, V1} -> 
        {nested, 'dec_NestedMessageContent'(V1, [16])};


%% 'genm'
    {131093, V1} -> 
        {genm, 'dec_GenMsgContent'(V1, [16])};


%% 'genp'
    {131094, V1} -> 
        {genp, 'dec_GenRepContent'(V1, [16])};


%% 'error'
    {131095, V1} -> 
        {error, 'dec_ErrorMsgContent'(V1, [16])};


%% 'certConf'
    {131096, V1} -> 
        {certConf, 'dec_CertConfirmContent'(V1, [16])};


%% 'pollReq'
    {131097, V1} -> 
        {pollReq, 'dec_PollReqContent'(V1, [16])};


%% 'pollRep'
    {131098, V1} -> 
        {pollRep, 'dec_PollRepContent'(V1, [16])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PKIProtection
%%================================
enc_PKIProtection(Val) ->
    enc_PKIProtection(Val, [<<3>>]).

enc_PKIProtection(Val, TagIn) ->
encode_unnamed_bit_string(Val, TagIn).


dec_PKIProtection(Tlv) ->
   dec_PKIProtection(Tlv, [3]).

dec_PKIProtection(Tlv, TagIn) ->
decode_native_bit_string(Tlv, TagIn).



%%================================
%%  ProtectedPart
%%================================
enc_ProtectedPart(Val) ->
    enc_ProtectedPart(Val, [<<48>>]).

enc_ProtectedPart(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute header(1)   External PKIXCMP-2023:PKIHeader
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIHeader'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute body(2)   External PKIXCMP-2023:PKIBody
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PKIBody'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ProtectedPart(Tlv) ->
   dec_ProtectedPart(Tlv, [16]).

dec_ProtectedPart(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute header(1)   External PKIXCMP-2023:PKIHeader
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIHeader'(V1, [16]),

%%-------------------------------------------------
%% attribute body(2)   External PKIXCMP-2023:PKIBody
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PKIBody'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'ProtectedPart',Term1,Term2},
Res1.


%%================================
%%  PBMParameter
%%================================
enc_PBMParameter(Val) ->
    enc_PBMParameter(Val, [<<48>>]).

enc_PBMParameter(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute owf(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PBMParameter_owf'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute iterationCount(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_PBMParameter_mac'(Cindex4, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMParameter_owf
%%================================
enc_PBMParameter_owf(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_12'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBMParameter_mac
%%================================
enc_PBMParameter_mac(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_14'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PBMParameter(Tlv) ->
   dec_PBMParameter(Tlv, [16]).

dec_PBMParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute salt(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute owf(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PBMParameter_owf'(V2, [16]),

%%-------------------------------------------------
%% attribute iterationCount(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_integer(V3, [2]),

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_PBMParameter_mac'(V4, [16]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter',Term1,Term2,Term3,Term4},
Res1.
'dec_PBMParameter_owf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_12'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter_owf',Term1,Term2},
Res1.
'dec_PBMParameter_mac'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_14'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBMParameter_mac',Term1,Term2},
Res1.


%%================================
%%  DHBMParameter
%%================================
enc_DHBMParameter(Val) ->
    enc_DHBMParameter(Val, [<<48>>]).

enc_DHBMParameter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute owf(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DHBMParameter_owf'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute mac(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_DHBMParameter_mac'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  DHBMParameter_owf
%%================================
enc_DHBMParameter_owf(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_16'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  DHBMParameter_mac
%%================================
enc_DHBMParameter_mac(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_18'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_DHBMParameter(Tlv) ->
   dec_DHBMParameter(Tlv, [16]).

dec_DHBMParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute owf(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DHBMParameter_owf'(V1, [16]),

%%-------------------------------------------------
%% attribute mac(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_DHBMParameter_mac'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DHBMParameter',Term1,Term2},
Res1.
'dec_DHBMParameter_owf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_16'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DHBMParameter_owf',Term1,Term2},
Res1.
'dec_DHBMParameter_mac'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_18'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'DHBMParameter_mac',Term1,Term2},
Res1.


%%================================
%%  KemBMParameter
%%================================
enc_KemBMParameter(Val) ->
    enc_KemBMParameter(Val, [<<48>>]).

enc_KemBMParameter(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute kdf(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_KemBMParameter_kdf'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute kemContext(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<4>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute len(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_KemBMParameter_mac'(Cindex4, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KemBMParameter_kdf
%%================================
enc_KemBMParameter_kdf(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_20'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KemBMParameter_mac
%%================================
enc_KemBMParameter_mac(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_22'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KemBMParameter(Tlv) ->
   dec_KemBMParameter(Tlv, [16]).

dec_KemBMParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute kdf(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_KemBMParameter_kdf'(V1, [16]),

%%-------------------------------------------------
%% attribute kemContext(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {decode_octet_string(V2, [4]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute len(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
Val1 = decode_integer(V3, [2]),
if 1 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute mac(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_KemBMParameter_mac'(V4, [16]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'KemBMParameter',Term1,Term2,Term3,Term4},
Res1.
'dec_KemBMParameter_kdf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_20'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KemBMParameter_kdf',Term1,Term2},
Res1.
'dec_KemBMParameter_mac'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_22'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KemBMParameter_mac',Term1,Term2},
Res1.


%%================================
%%  PKIStatus
%%================================
enc_PKIStatus(Val) ->
    enc_PKIStatus(Val, [<<2>>]).

enc_PKIStatus(Val, TagIn) ->
encode_integer(Val, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}], TagIn).


dec_PKIStatus(Tlv) ->
   dec_PKIStatus(Tlv, [2]).

dec_PKIStatus(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}])
end
.



%%================================
%%  PKIFailureInfo
%%================================
enc_PKIFailureInfo(Val) ->
    enc_PKIFailureInfo(Val, [<<3>>]).

enc_PKIFailureInfo(Val, TagIn) ->
encode_named_bit_string(Val, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{badDataFormat,5},{wrongAuthority,6},{incorrectData,7},{missingTimeStamp,8},{badPOP,9},{certRevoked,10},{certConfirmed,11},{wrongIntegrity,12},{badRecipientNonce,13},{timeNotAvailable,14},{unacceptedPolicy,15},{unacceptedExtension,16},{addInfoNotAvailable,17},{badSenderNonce,18},{badCertTemplate,19},{signerNotTrusted,20},{transactionIdInUse,21},{unsupportedVersion,22},{notAuthorized,23},{systemUnavail,24},{systemFailure,25},{duplicateCertReq,26}], TagIn).


dec_PKIFailureInfo(Tlv) ->
   dec_PKIFailureInfo(Tlv, [3]).

dec_PKIFailureInfo(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{badDataFormat,5},{wrongAuthority,6},{incorrectData,7},{missingTimeStamp,8},{badPOP,9},{certRevoked,10},{certConfirmed,11},{wrongIntegrity,12},{badRecipientNonce,13},{timeNotAvailable,14},{unacceptedPolicy,15},{unacceptedExtension,16},{addInfoNotAvailable,17},{badSenderNonce,18},{badCertTemplate,19},{signerNotTrusted,20},{transactionIdInUse,21},{unsupportedVersion,22},{notAuthorized,23},{systemUnavail,24},{systemFailure,25},{duplicateCertReq,26}], TagIn).



%%================================
%%  PKIStatusInfo
%%================================
enc_PKIStatusInfo(Val) ->
    enc_PKIStatusInfo(Val, [<<48>>]).

enc_PKIStatusInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute status(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}], [<<2>>]),

%%-------------------------------------------------
%% attribute statusString(2)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIFreeText'(Cindex2, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute failInfo(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_named_bit_string(Cindex3, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{badDataFormat,5},{wrongAuthority,6},{incorrectData,7},{missingTimeStamp,8},{badPOP,9},{certRevoked,10},{certConfirmed,11},{wrongIntegrity,12},{badRecipientNonce,13},{timeNotAvailable,14},{unacceptedPolicy,15},{unacceptedExtension,16},{addInfoNotAvailable,17},{badSenderNonce,18},{badCertTemplate,19},{signerNotTrusted,20},{transactionIdInUse,21},{unsupportedVersion,22},{notAuthorized,23},{systemUnavail,24},{systemFailure,25},{duplicateCertReq,26}], [<<3>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PKIStatusInfo(Tlv) ->
   dec_PKIStatusInfo(Tlv, [16]).

dec_PKIStatusInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute status(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}])
end
,

%%-------------------------------------------------
%% attribute statusString(2)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PKIFreeText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute failInfo(3) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{3,V3}|TempTlv4] ->
    {decode_named_bit_string(V3, [{badAlg,0},{badMessageCheck,1},{badRequest,2},{badTime,3},{badCertId,4},{badDataFormat,5},{wrongAuthority,6},{incorrectData,7},{missingTimeStamp,8},{badPOP,9},{certRevoked,10},{certConfirmed,11},{wrongIntegrity,12},{badRecipientNonce,13},{timeNotAvailable,14},{unacceptedPolicy,15},{unacceptedExtension,16},{addInfoNotAvailable,17},{badSenderNonce,18},{badCertTemplate,19},{signerNotTrusted,20},{transactionIdInUse,21},{unsupportedVersion,22},{notAuthorized,23},{systemUnavail,24},{systemFailure,25},{duplicateCertReq,26}], []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PKIStatusInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  OOBCert
%%================================
enc_OOBCert(Val) ->
    enc_OOBCert(Val, []).

enc_OOBCert(Val, TagIn) ->
   enc_CMPCertificate(Val, TagIn).


dec_OOBCert(Tlv) ->
   dec_OOBCert(Tlv, []).

dec_OOBCert(Tlv, TagIn) ->
'dec_CMPCertificate'(Tlv, TagIn).



%%================================
%%  OOBCertHash
%%================================
enc_OOBCertHash(Val) ->
    enc_OOBCertHash(Val, [<<48>>]).

enc_OOBCertHash(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute hashAlg(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OOBCertHash_hashAlg'(Cindex1, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute certId(2)   External PKIXCRMF-2009:CertId OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIXCRMF-2009':'enc_CertId'(Cindex2, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute hashVal(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OOBCertHash_hashAlg
%%================================
enc_OOBCertHash_hashAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_24'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OOBCertHash(Tlv) ->
   dec_OOBCertHash(Tlv, [16]).

dec_OOBCertHash(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute hashAlg(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_OOBCertHash_hashAlg'(V1, [16]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute certId(2)   External PKIXCRMF-2009:CertId OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'PKIXCRMF-2009':'dec_CertId'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute hashVal(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OOBCertHash',Term1,Term2,Term3},
Res1.
'dec_OOBCertHash_hashAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_24'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OOBCertHash_hashAlg',Term1,Term2},
Res1.


%%================================
%%  POPODecKeyChallContent
%%================================
enc_POPODecKeyChallContent(Val) ->
    enc_POPODecKeyChallContent(Val, [<<48>>]).

enc_POPODecKeyChallContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_POPODecKeyChallContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_POPODecKeyChallContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_POPODecKeyChallContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Challenge'(H, [<<48>>]),
   'enc_POPODecKeyChallContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_POPODecKeyChallContent(Tlv) ->
   dec_POPODecKeyChallContent(Tlv, [16]).

dec_POPODecKeyChallContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Challenge'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Challenge
%%================================
enc_Challenge(Val) ->
    enc_Challenge(Val, [<<48>>]).

enc_Challenge(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute owf(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Challenge_owf'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute witness(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute challenge(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute encryptedRand(4)   External CryptographicMessageSyntax-2009:EnvelopedData OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'CryptographicMessageSyntax-2009':'enc_EnvelopedData'(Cindex4, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Challenge_owf
%%================================
enc_Challenge_owf(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Challenge(Tlv) ->
   dec_Challenge(Tlv, [16]).

dec_Challenge(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute owf(1) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_Challenge_owf'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute witness(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute challenge(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

%%-------------------------------------------------
%% attribute encryptedRand(4)   External CryptographicMessageSyntax-2009:EnvelopedData OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'CryptographicMessageSyntax-2009':'dec_EnvelopedData'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'Challenge',Term1,Term2,Term3,Term4},
Res1.
'dec_Challenge_owf'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Challenge_owf',Term1,Term2},
Res1.


%%================================
%%  Rand
%%================================
enc_Rand(Val) ->
    enc_Rand(Val, [<<48>>]).

enc_Rand(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute int(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute sender(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Implicit-2009':'enc_GeneralName'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Rand(Tlv) ->
   dec_Rand(Tlv, [16]).

dec_Rand(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute int(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute sender(2)   External PKIX1Implicit-2009:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Implicit-2009':'dec_GeneralName'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'Rand',Term1,Term2},
Res1.


%%================================
%%  POPODecKeyRespContent
%%================================
enc_POPODecKeyRespContent(Val) ->
    enc_POPODecKeyRespContent(Val, [<<48>>]).

enc_POPODecKeyRespContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_POPODecKeyRespContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_POPODecKeyRespContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_POPODecKeyRespContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_integer(H, [<<2>>]),
   'enc_POPODecKeyRespContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_POPODecKeyRespContent(Tlv) ->
   dec_POPODecKeyRespContent(Tlv, [16]).

dec_POPODecKeyRespContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[decode_integer(V1, [2]) || V1 <- Tlv1].




%%================================
%%  CertRepMessage
%%================================
enc_CertRepMessage(Val) ->
    enc_CertRepMessage(Val, [<<48>>]).

enc_CertRepMessage(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute caPubs(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertRepMessage_caPubs'(Cindex1, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute response(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CertRepMessage_response'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertRepMessage_caPubs
%%================================
enc_CertRepMessage_caPubs(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertRepMessage_caPubs_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertRepMessage_caPubs_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertRepMessage_caPubs_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CMPCertificate'(H, []),
   'enc_CertRepMessage_caPubs_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  CertRepMessage_response
%%================================
enc_CertRepMessage_response(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_CertRepMessage_response_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertRepMessage_response_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertRepMessage_response_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertResponse'(H, [<<48>>]),
   'enc_CertRepMessage_response_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertRepMessage(Tlv) ->
   dec_CertRepMessage(Tlv, [16]).

dec_CertRepMessage(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute caPubs(1) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131073,V1}|TempTlv2] ->
    {'dec_CertRepMessage_caPubs'(V1, [16]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute response(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CertRepMessage_response'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertRepMessage',Term1,Term2},
Res1.
'dec_CertRepMessage_caPubs'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CMPCertificate'(V1, []) || V1 <- Tlv1].


'dec_CertRepMessage_response'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertResponse'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertResponse
%%================================
enc_CertResponse(Val) ->
    enc_CertResponse(Val, [<<48>>]).

enc_CertResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute status(2)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PKIStatusInfo'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute certifiedKeyPair(3)   External PKIXCMP-2023:CertifiedKeyPair OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertifiedKeyPair'(Cindex3, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute rspInfo(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertResponse(Tlv) ->
   dec_CertResponse(Tlv, [16]).

dec_CertResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute status(2)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PKIStatusInfo'(V2, [16]),

%%-------------------------------------------------
%% attribute certifiedKeyPair(3)   External PKIXCMP-2023:CertifiedKeyPair OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_CertifiedKeyPair'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute rspInfo(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{4,V4}|TempTlv5] ->
    {decode_octet_string(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertResponse',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  CertifiedKeyPair
%%================================
enc_CertifiedKeyPair(Val) ->
    enc_CertifiedKeyPair(Val, [<<48>>]).

enc_CertifiedKeyPair(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certOrEncCert(1)   External PKIXCMP-2023:CertOrEncCert
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CertOrEncCert'(Cindex1, []),

%%-------------------------------------------------
%% attribute privateKey(2)   External PKIXCRMF-2009:EncryptedKey OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIXCRMF-2009':'enc_EncryptedKey'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute publicationInfo(3)   External PKIXCRMF-2009:PKIPublicationInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIXCRMF-2009':'enc_PKIPublicationInfo'(Cindex3, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertifiedKeyPair(Tlv) ->
   dec_CertifiedKeyPair(Tlv, [16]).

dec_CertifiedKeyPair(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certOrEncCert(1)   External PKIXCMP-2023:CertOrEncCert
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CertOrEncCert'(V1, []),

%%-------------------------------------------------
%% attribute privateKey(2)   External PKIXCRMF-2009:EncryptedKey OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'PKIXCRMF-2009':'dec_EncryptedKey'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute publicationInfo(3)   External PKIXCRMF-2009:PKIPublicationInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'PKIXCRMF-2009':'dec_PKIPublicationInfo'(V3, [16]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CertifiedKeyPair',Term1,Term2,Term3},
Res1.


%%================================
%%  CertOrEncCert
%%================================
enc_CertOrEncCert(Val) ->
    enc_CertOrEncCert(Val, []).

enc_CertOrEncCert(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      certificate ->
         'enc_CMPCertificate'(element(2,Val), [<<160>>]);
      encryptedCert ->
         'PKIXCRMF-2009':'enc_EncryptedKey'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CertOrEncCert(Tlv) ->
   dec_CertOrEncCert(Tlv, []).

dec_CertOrEncCert(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'certificate'
    {131072, V1} -> 
        {certificate, 'dec_CMPCertificate'(V1, [])};


%% 'encryptedCert'
    {131073, V1} -> 
        {encryptedCert, 'PKIXCRMF-2009':'dec_EncryptedKey'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  KeyRecRepContent
%%================================
enc_KeyRecRepContent(Val) ->
    enc_KeyRecRepContent(Val, [<<48>>]).

enc_KeyRecRepContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute status(1)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIStatusInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute newSigCert(2)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CMPCertificate'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute caCerts(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_KeyRecRepContent_caCerts'(Cindex3, [<<48>>,<<161>>])
       end,

%%-------------------------------------------------
%% attribute keyPairHist(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_KeyRecRepContent_keyPairHist'(Cindex4, [<<48>>,<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KeyRecRepContent_caCerts
%%================================
enc_KeyRecRepContent_caCerts(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_KeyRecRepContent_caCerts_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_KeyRecRepContent_caCerts_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_KeyRecRepContent_caCerts_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CMPCertificate'(H, []),
   'enc_KeyRecRepContent_caCerts_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  KeyRecRepContent_keyPairHist
%%================================
enc_KeyRecRepContent_keyPairHist(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_KeyRecRepContent_keyPairHist_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_KeyRecRepContent_keyPairHist_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_KeyRecRepContent_keyPairHist_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertifiedKeyPair'(H, [<<48>>]),
   'enc_KeyRecRepContent_keyPairHist_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_KeyRecRepContent(Tlv) ->
   dec_KeyRecRepContent(Tlv, [16]).

dec_KeyRecRepContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute status(1)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIStatusInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute newSigCert(2)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_CMPCertificate'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute caCerts(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_KeyRecRepContent_caCerts'(V3, [16]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute keyPairHist(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131074,V4}|TempTlv5] ->
    {'dec_KeyRecRepContent_keyPairHist'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'KeyRecRepContent',Term1,Term2,Term3,Term4},
Res1.
'dec_KeyRecRepContent_caCerts'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CMPCertificate'(V1, []) || V1 <- Tlv1].


'dec_KeyRecRepContent_keyPairHist'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertifiedKeyPair'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  RevReqContent
%%================================
enc_RevReqContent(Val) ->
    enc_RevReqContent(Val, [<<48>>]).

enc_RevReqContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RevReqContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevReqContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevReqContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RevDetails'(H, [<<48>>]),
   'enc_RevReqContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RevReqContent(Tlv) ->
   dec_RevReqContent(Tlv, [16]).

dec_RevReqContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RevDetails'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  RevDetails
%%================================
enc_RevDetails(Val) ->
    enc_RevDetails(Val, [<<48>>]).

enc_RevDetails(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute certDetails(1)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIXCRMF-2009':'enc_CertTemplate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute crlEntryDetails(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevDetails_crlEntryDetails'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  RevDetails_crlEntryDetails
%%================================
enc_RevDetails_crlEntryDetails(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RevDetails_crlEntryDetails_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevDetails_crlEntryDetails_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevDetails_crlEntryDetails_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RevDetails_crlEntryDetails_Extension'(H, [<<48>>]),
   'enc_RevDetails_crlEntryDetails_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RevDetails_crlEntryDetails_Extension
%%================================
enc_RevDetails_crlEntryDetails_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RevDetails(Tlv) ->
   dec_RevDetails(Tlv, [16]).

dec_RevDetails(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certDetails(1)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIXCRMF-2009':'dec_CertTemplate'(V1, [16]),

%%-------------------------------------------------
%% attribute crlEntryDetails(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_RevDetails_crlEntryDetails'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RevDetails',Term1,Term2},
Res1.
'dec_RevDetails_crlEntryDetails'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RevDetails_crlEntryDetails_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_RevDetails_crlEntryDetails_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  RevRepContent
%%================================
enc_RevRepContent(Val) ->
    enc_RevRepContent(Val, [<<48>>]).

enc_RevRepContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute status(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_RevRepContent_status'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute revCerts(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevRepContent_revCerts'(Cindex2, [<<48>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute crls(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevRepContent_crls'(Cindex3, [<<48>>,<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  RevRepContent_status
%%================================
enc_RevRepContent_status(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RevRepContent_status_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevRepContent_status_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevRepContent_status_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PKIStatusInfo'(H, [<<48>>]),
   'enc_RevRepContent_status_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RevRepContent_revCerts
%%================================
enc_RevRepContent_revCerts(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RevRepContent_revCerts_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevRepContent_revCerts_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevRepContent_revCerts_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIXCRMF-2009':'enc_CertId'(H, [<<48>>]),
   'enc_RevRepContent_revCerts_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RevRepContent_crls
%%================================
enc_RevRepContent_crls(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RevRepContent_crls_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevRepContent_crls_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevRepContent_crls_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit-2009':'enc_CertificateList'(H, [<<48>>]),
   'enc_RevRepContent_crls_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RevRepContent(Tlv) ->
   dec_RevRepContent(Tlv, [16]).

dec_RevRepContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute status(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_RevRepContent_status'(V1, [16]),

%%-------------------------------------------------
%% attribute revCerts(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_RevRepContent_revCerts'(V2, [16]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute crls(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_RevRepContent_crls'(V3, [16]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RevRepContent',Term1,Term2,Term3},
Res1.
'dec_RevRepContent_status'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PKIStatusInfo'(V1, [16]) || V1 <- Tlv1].


'dec_RevRepContent_revCerts'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['PKIXCRMF-2009':'dec_CertId'(V1, [16]) || V1 <- Tlv1].


'dec_RevRepContent_crls'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['PKIX1Explicit-2009':'dec_CertificateList'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CAKeyUpdAnnContent
%%================================
enc_CAKeyUpdAnnContent(Val) ->
    enc_CAKeyUpdAnnContent(Val, [<<48>>]).

enc_CAKeyUpdAnnContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute oldWithNew(1)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CMPCertificate'(Cindex1, []),

%%-------------------------------------------------
%% attribute newWithOld(2)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_CMPCertificate'(Cindex2, []),

%%-------------------------------------------------
%% attribute newWithNew(3)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_CMPCertificate'(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CAKeyUpdAnnContent(Tlv) ->
   dec_CAKeyUpdAnnContent(Tlv, [16]).

dec_CAKeyUpdAnnContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute oldWithNew(1)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CMPCertificate'(V1, []),

%%-------------------------------------------------
%% attribute newWithOld(2)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_CMPCertificate'(V2, []),

%%-------------------------------------------------
%% attribute newWithNew(3)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_CMPCertificate'(V3, []),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'CAKeyUpdAnnContent',Term1,Term2,Term3},
Res1.


%%================================
%%  CAKeyUpdContent
%%================================
enc_CAKeyUpdContent(Val) ->
    enc_CAKeyUpdContent(Val, []).

enc_CAKeyUpdContent(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      cAKeyUpdAnnV2 ->
         'enc_CAKeyUpdAnnContent'(element(2,Val), [<<48>>]);
      cAKeyUpdAnnV3 ->
         'enc_RootCaKeyUpdateContent'(element(2,Val), [<<48>>,<<160>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CAKeyUpdContent(Tlv) ->
   dec_CAKeyUpdContent(Tlv, []).

dec_CAKeyUpdContent(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'cAKeyUpdAnnV2'
    {16, V1} -> 
        {cAKeyUpdAnnV2, 'dec_CAKeyUpdAnnContent'(V1, [])};


%% 'cAKeyUpdAnnV3'
    {131072, V1} -> 
        {cAKeyUpdAnnV3, 'dec_RootCaKeyUpdateContent'(V1, [16])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  CertAnnContent
%%================================
enc_CertAnnContent(Val) ->
    enc_CertAnnContent(Val, []).

enc_CertAnnContent(Val, TagIn) ->
   enc_CMPCertificate(Val, TagIn).


dec_CertAnnContent(Tlv) ->
   dec_CertAnnContent(Tlv, []).

dec_CertAnnContent(Tlv, TagIn) ->
'dec_CMPCertificate'(Tlv, TagIn).



%%================================
%%  RevAnnContent
%%================================
enc_RevAnnContent(Val) ->
    enc_RevAnnContent(Val, [<<48>>]).

enc_RevAnnContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute status(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}], [<<2>>]),

%%-------------------------------------------------
%% attribute certId(2)   External PKIXCRMF-2009:CertId
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIXCRMF-2009':'enc_CertId'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute willBeRevokedAt(3) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<24>>]),

%%-------------------------------------------------
%% attribute badSinceDate(4) with type GeneralizedTime
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<24>>]),

%%-------------------------------------------------
%% attribute crlDetails(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RevAnnContent_crlDetails'(Cindex5, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  RevAnnContent_crlDetails
%%================================
enc_RevAnnContent_crlDetails(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RevAnnContent_crlDetails_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RevAnnContent_crlDetails_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RevAnnContent_crlDetails_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RevAnnContent_crlDetails_Extension'(H, [<<48>>]),
   'enc_RevAnnContent_crlDetails_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  RevAnnContent_crlDetails_Extension
%%================================
enc_RevAnnContent_crlDetails_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_1(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RevAnnContent(Tlv) ->
   dec_RevAnnContent(Tlv, [16]).

dec_RevAnnContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute status(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{accepted,0},{grantedWithMods,1},{rejection,2},{waiting,3},{revocationWarning,4},{revocationNotification,5},{keyUpdateWarning,6}])
end
,

%%-------------------------------------------------
%% attribute certId(2)   External PKIXCRMF-2009:CertId
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIXCRMF-2009':'dec_CertId'(V2, [16]),

%%-------------------------------------------------
%% attribute willBeRevokedAt(3) with type GeneralizedTime
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [24]))
end
,

%%-------------------------------------------------
%% attribute badSinceDate(4) with type GeneralizedTime
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = begin
binary_to_list(decode_restricted_string(V4, [24]))
end
,

%%-------------------------------------------------
%% attribute crlDetails(5) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{16,V5}|TempTlv6] ->
    {'dec_RevAnnContent_crlDetails'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv6}}}) % extra fields not allowed
end,
Res1 = {'RevAnnContent',Term1,Term2,Term3,Term4,Term5},
Res1.
'dec_RevAnnContent_crlDetails'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RevAnnContent_crlDetails_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_RevAnnContent_crlDetails_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  CRLAnnContent
%%================================
enc_CRLAnnContent(Val) ->
    enc_CRLAnnContent(Val, [<<48>>]).

enc_CRLAnnContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CRLAnnContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CRLAnnContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CRLAnnContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit-2009':'enc_CertificateList'(H, [<<48>>]),
   'enc_CRLAnnContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CRLAnnContent(Tlv) ->
   dec_CRLAnnContent(Tlv, [16]).

dec_CRLAnnContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['PKIX1Explicit-2009':'dec_CertificateList'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PKIConfirmContent
%%================================
enc_PKIConfirmContent(Val) ->
    enc_PKIConfirmContent(Val, [<<5>>]).

enc_PKIConfirmContent(Val, TagIn) ->
encode_null(Val, TagIn).


dec_PKIConfirmContent(Tlv) ->
   dec_PKIConfirmContent(Tlv, [5]).

dec_PKIConfirmContent(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  NestedMessageContent
%%================================
enc_NestedMessageContent(Val) ->
    enc_NestedMessageContent(Val, [<<48>>]).

enc_NestedMessageContent(Val, TagIn) ->
   enc_PKIMessages(Val, TagIn).


dec_NestedMessageContent(Tlv) ->
   dec_NestedMessageContent(Tlv, [16]).

dec_NestedMessageContent(Tlv, TagIn) ->
'dec_PKIMessages'(Tlv, TagIn).



%%================================
%%  CertReqTemplateContent
%%================================
enc_CertReqTemplateContent(Val) ->
    enc_CertReqTemplateContent(Val, [<<48>>]).

enc_CertReqTemplateContent(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute certTemplate(1)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'PKIXCRMF-2009':'enc_CertTemplate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute keySpec(2)   External PKIXCRMF-2009:Controls OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIXCRMF-2009':'enc_Controls'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertReqTemplateContent(Tlv) ->
   dec_CertReqTemplateContent(Tlv, [16]).

dec_CertReqTemplateContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certTemplate(1)   External PKIXCRMF-2009:CertTemplate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'PKIXCRMF-2009':'dec_CertTemplate'(V1, [16]),

%%-------------------------------------------------
%% attribute keySpec(2)   External PKIXCRMF-2009:Controls OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'PKIXCRMF-2009':'dec_Controls'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertReqTemplateContent',Term1,Term2},
Res1.


%%================================
%%  AttributeTypeAndValue
%%================================
enc_AttributeTypeAndValue(Val) ->
    enc_AttributeTypeAndValue(Val, [<<48>>]).

enc_AttributeTypeAndValue(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objtype = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_25'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeTypeAndValue(Tlv) ->
   dec_AttributeTypeAndValue(Tlv, [16]).

dec_AttributeTypeAndValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_25'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeTypeAndValue',Term1,Term2},
Res1.


%%================================
%%  AltCertTemplate
%%================================
enc_AltCertTemplate(Val) ->
    enc_AltCertTemplate(Val, [<<48>>]).

enc_AltCertTemplate(Val, TagIn) ->
   enc_AttributeTypeAndValue(Val, TagIn).


dec_AltCertTemplate(Tlv) ->
   dec_AltCertTemplate(Tlv, [16]).

dec_AltCertTemplate(Tlv, TagIn) ->
'dec_AttributeTypeAndValue'(Tlv, TagIn).



%%================================
%%  AlgIdCtrl
%%================================
enc_AlgIdCtrl(Val) ->
    enc_AlgIdCtrl(Val, [<<48>>]).

enc_AlgIdCtrl(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_27'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AlgIdCtrl(Tlv) ->
   dec_AlgIdCtrl(Tlv, [16]).

dec_AlgIdCtrl(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_27'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AlgIdCtrl',Term1,Term2},
Res1.


%%================================
%%  RsaKeyLenCtrl
%%================================
enc_RsaKeyLenCtrl(Val) ->
    enc_RsaKeyLenCtrl(Val, [<<2>>]).

enc_RsaKeyLenCtrl(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_RsaKeyLenCtrl(Tlv) ->
   dec_RsaKeyLenCtrl(Tlv, [2]).

dec_RsaKeyLenCtrl(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 1 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  RootCaKeyUpdateContent
%%================================
enc_RootCaKeyUpdateContent(Val) ->
    enc_RootCaKeyUpdateContent(Val, [<<48>>]).

enc_RootCaKeyUpdateContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute newWithNew(1)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CMPCertificate'(Cindex1, []),

%%-------------------------------------------------
%% attribute newWithOld(2)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CMPCertificate'(Cindex2, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute oldWithNew(3)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CMPCertificate'(Cindex3, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RootCaKeyUpdateContent(Tlv) ->
   dec_RootCaKeyUpdateContent(Tlv, [16]).

dec_RootCaKeyUpdateContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute newWithNew(1)   External PKIXCMP-2023:CMPCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CMPCertificate'(V1, []),

%%-------------------------------------------------
%% attribute newWithOld(2)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {'dec_CMPCertificate'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute oldWithNew(3)   External PKIXCMP-2023:CMPCertificate OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {'dec_CMPCertificate'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'RootCaKeyUpdateContent',Term1,Term2,Term3},
Res1.


%%================================
%%  CRLSource
%%================================
enc_CRLSource(Val) ->
    enc_CRLSource(Val, []).

enc_CRLSource(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      dpn ->
         'PKIX1Implicit-2009':'enc_DistributionPointName'(element(2,Val), [<<160>>]);
      issuer ->
         'PKIX1Implicit-2009':'enc_GeneralNames'(element(2,Val), [<<48>>,<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_CRLSource(Tlv) ->
   dec_CRLSource(Tlv, []).

dec_CRLSource(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'dpn'
    {131072, V1} -> 
        {dpn, 'PKIX1Implicit-2009':'dec_DistributionPointName'(V1, [])};


%% 'issuer'
    {131073, V1} -> 
        {issuer, 'PKIX1Implicit-2009':'dec_GeneralNames'(V1, [16])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  CRLStatus
%%================================
enc_CRLStatus(Val) ->
    enc_CRLStatus(Val, [<<48>>]).

enc_CRLStatus(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute source(1)   External PKIXCMP-2023:CRLSource
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_CRLSource'(Cindex1, []),

%%-------------------------------------------------
%% attribute thisUpdate(2)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit-2009':'enc_Time'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CRLStatus(Tlv) ->
   dec_CRLStatus(Tlv, [16]).

dec_CRLStatus(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute source(1)   External PKIXCMP-2023:CRLSource
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_CRLSource'(V1, []),

%%-------------------------------------------------
%% attribute thisUpdate(2)   External PKIX1Explicit-2009:Time OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {23,_}|TempTlv3] ->
    {'PKIX1Explicit-2009':'dec_Time'(V2, []), TempTlv3};
[V2 = {24,_}|TempTlv3] ->
    {'PKIX1Explicit-2009':'dec_Time'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CRLStatus',Term1,Term2},
Res1.


%%================================
%%  KemCiphertextInfo
%%================================
enc_KemCiphertextInfo(Val) ->
    enc_KemCiphertextInfo(Val, [<<48>>]).

enc_KemCiphertextInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute kem(1) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_KemCiphertextInfo_kem'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute ct(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  KemCiphertextInfo_kem
%%================================
enc_KemCiphertextInfo_kem(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_29'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KemCiphertextInfo(Tlv) ->
   dec_KemCiphertextInfo(Tlv, [16]).

dec_KemCiphertextInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute kem(1) with type SEQUENCE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_KemCiphertextInfo_kem'(V1, [16]),

%%-------------------------------------------------
%% attribute ct(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KemCiphertextInfo',Term1,Term2},
Res1.
'dec_KemCiphertextInfo_kem'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_29'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KemCiphertextInfo_kem',Term1,Term2},
Res1.


%%================================
%%  KemOtherInfo
%%================================
enc_KemOtherInfo(Val) ->
    enc_KemOtherInfo(Val, [<<48>>]).

enc_KemOtherInfo(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute staticString(1)   External PKIXCMP-2023:PKIFreeText
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIFreeText'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute transactionID(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute kemContext(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KemOtherInfo(Tlv) ->
   dec_KemOtherInfo(Tlv, [16]).

dec_KemOtherInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute staticString(1)   External PKIXCMP-2023:PKIFreeText
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIFreeText'(V1, [16]),

%%-------------------------------------------------
%% attribute transactionID(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

%%-------------------------------------------------
%% attribute kemContext(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {decode_octet_string(V3, [4]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'KemOtherInfo',Term1,Term2,Term3},
Res1.


%%================================
%%  InfoTypeAndValue
%%================================
enc_InfoTypeAndValue(Val) ->
    enc_InfoTypeAndValue(Val, [<<48>>]).

enc_InfoTypeAndValue(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjinfoType = 
   'PKIXCMP-2023':'getenc_SupportedInfoSet'(                                   Cindex1),

%%-------------------------------------------------
%% attribute infoType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute infoValue(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjinfoType('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_InfoTypeAndValue(Tlv) ->
   dec_InfoTypeAndValue(Tlv, [16]).

dec_InfoTypeAndValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute infoType(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute infoValue(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjinfoTypeTerm1 =
   'PKIXCMP-2023':'getdec_SupportedInfoSet'(Term1),
Term2 = 
   case (catch DecObjinfoTypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'InfoTypeAndValue',Term1,Term2},
Res1.


%%================================
%%  GenMsgContent
%%================================
enc_GenMsgContent(Val) ->
    enc_GenMsgContent(Val, [<<48>>]).

enc_GenMsgContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GenMsgContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GenMsgContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GenMsgContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_InfoTypeAndValue'(H, [<<48>>]),
   'enc_GenMsgContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GenMsgContent(Tlv) ->
   dec_GenMsgContent(Tlv, [16]).

dec_GenMsgContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_InfoTypeAndValue'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  GenRepContent
%%================================
enc_GenRepContent(Val) ->
    enc_GenRepContent(Val, [<<48>>]).

enc_GenRepContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GenRepContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_GenRepContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GenRepContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_InfoTypeAndValue'(H, [<<48>>]),
   'enc_GenRepContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_GenRepContent(Tlv) ->
   dec_GenRepContent(Tlv, [16]).

dec_GenRepContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_InfoTypeAndValue'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ErrorMsgContent
%%================================
enc_ErrorMsgContent(Val) ->
    enc_ErrorMsgContent(Val, [<<48>>]).

enc_ErrorMsgContent(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute pKIStatusInfo(1)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PKIStatusInfo'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute errorCode(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute errorDetails(3)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIFreeText'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ErrorMsgContent(Tlv) ->
   dec_ErrorMsgContent(Tlv, [16]).

dec_ErrorMsgContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pKIStatusInfo(1)   External PKIXCMP-2023:PKIStatusInfo
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PKIStatusInfo'(V1, [16]),

%%-------------------------------------------------
%% attribute errorCode(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{2,V2}|TempTlv3] ->
    {decode_integer(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute errorDetails(3)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_PKIFreeText'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'ErrorMsgContent',Term1,Term2,Term3},
Res1.


%%================================
%%  CertConfirmContent
%%================================
enc_CertConfirmContent(Val) ->
    enc_CertConfirmContent(Val, [<<48>>]).

enc_CertConfirmContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertConfirmContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_CertConfirmContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertConfirmContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CertStatus'(H, [<<48>>]),
   'enc_CertConfirmContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_CertConfirmContent(Tlv) ->
   dec_CertConfirmContent(Tlv, [16]).

dec_CertConfirmContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CertStatus'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertStatus
%%================================
enc_CertStatus(Val) ->
    enc_CertStatus(Val, [<<48>>]).

enc_CertStatus(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute certHash(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute certReqId(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute statusInfo(3)   External PKIXCMP-2023:PKIStatusInfo OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIStatusInfo'(Cindex3, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute hashAlg(4) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_CertStatus_hashAlg'(Cindex4, [<<48>>,<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  CertStatus_hashAlg
%%================================
enc_CertStatus_hashAlg(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIXCMP-2023':'getenc_internal_object_set_argument_10'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CertStatus(Tlv) ->
   dec_CertStatus(Tlv, [16]).

dec_CertStatus(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certHash(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_octet_string(V1, [4]),

%%-------------------------------------------------
%% attribute certReqId(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute statusInfo(3)   External PKIXCMP-2023:PKIStatusInfo OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_PKIStatusInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute hashAlg(4) with type SEQUENCE OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {'dec_CertStatus_hashAlg'(V4, [16]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'CertStatus',Term1,Term2,Term3,Term4},
Res1.
'dec_CertStatus_hashAlg'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIXCMP-2023':'getdec_internal_object_set_argument_10'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'CertStatus_hashAlg',Term1,Term2},
Res1.


%%================================
%%  PollReqContent
%%================================
enc_PollReqContent(Val) ->
    enc_PollReqContent(Val, [<<48>>]).

enc_PollReqContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PollReqContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PollReqContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PollReqContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PollReqContent_SEQOF'(H, [<<48>>]),
   'enc_PollReqContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PollReqContent_SEQOF
%%================================
enc_PollReqContent_SEQOF(Val, TagIn) ->
   {_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PollReqContent(Tlv) ->
   dec_PollReqContent(Tlv, [16]).

dec_PollReqContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PollReqContent_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_PollReqContent_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

case Tlv2 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv2}}}) % extra fields not allowed
end,
Res1 = {'PollReqContent_SEQOF',Term1},
Res1.


%%================================
%%  PollRepContent
%%================================
enc_PollRepContent(Val) ->
    enc_PollRepContent(Val, [<<48>>]).

enc_PollRepContent(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PollRepContent_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PollRepContent_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PollRepContent_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PollRepContent_SEQOF'(H, [<<48>>]),
   'enc_PollRepContent_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PollRepContent_SEQOF
%%================================
enc_PollRepContent_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute checkAfter(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute reason(3)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PKIFreeText'(Cindex3, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PollRepContent(Tlv) ->
   dec_PollRepContent(Tlv, [16]).

dec_PollRepContent(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PollRepContent_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_PollRepContent_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute certReqId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_integer(V1, [2]),

%%-------------------------------------------------
%% attribute checkAfter(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute reason(3)   External PKIXCMP-2023:PKIFreeText OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{16,V3}|TempTlv4] ->
    {'dec_PKIFreeText'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'PollRepContent_SEQOF',Term1,Term2,Term3},
Res1.
'id-PasswordBasedMac'() ->
{1,2,840,113533,7,66,13}.

'id-DHBasedMac'() ->
{1,2,840,113533,7,66,30}.

'id-KemBasedMac'() ->
{1,2,840,113533,7,66,16}.

'id-regCtrl-altCertTemplate'() ->
{1,3,6,1,5,5,7,5,1,7}.

'id-regCtrl-algId'() ->
{1,3,6,1,5,5,7,5,1,11}.

'id-regCtrl-rsaKeyLen'() ->
{1,3,6,1,5,5,7,5,1,12}.

'id-kp-cmKGA'() ->
{1,3,6,1,5,5,7,3,32}.




%%================================
%%  regCtrl-altCertTemplate
%%================================
'enc_regCtrl-altCertTemplate'('Type', Val, _RestPrimFieldName) ->
   enc_AltCertTemplate(Val, [<<48>>]);
'enc_regCtrl-altCertTemplate'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-altCertTemplate'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AltCertTemplate(Tlv, [16]);
'dec_regCtrl-altCertTemplate'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  regCtrl-algId
%%================================
'enc_regCtrl-algId'('Type', Val, _RestPrimFieldName) ->
   enc_AlgIdCtrl(Val, [<<48>>]);
'enc_regCtrl-algId'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-algId'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_AlgIdCtrl(Tlv, [16]);
'dec_regCtrl-algId'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  regCtrl-rsaKeyLen
%%================================
'enc_regCtrl-rsaKeyLen'('Type', Val, _RestPrimFieldName) ->
   enc_RsaKeyLenCtrl(Val, [<<2>>]);
'enc_regCtrl-rsaKeyLen'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_regCtrl-rsaKeyLen'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RsaKeyLenCtrl(Tlv, [2]);
'dec_regCtrl-rsaKeyLen'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  ExpandedRegControlSet
%%================================
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-regToken'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-authenticator'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-pkiPublicationInfo'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-pkiArchiveOptions'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-oldCertID'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'enc_regCtrl-protocolEncrKey'(T,V,O) end;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,7} ->
    fun 'enc_regCtrl-altCertTemplate'/3;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,11} ->
    fun 'enc_regCtrl-algId'/3;
getenc_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,12} ->
    fun 'enc_regCtrl-rsaKeyLen'/3;
getenc_ExpandedRegControlSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,1} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-regToken'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,2} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-authenticator'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,3} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-pkiPublicationInfo'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,4} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-pkiArchiveOptions'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,5} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-oldCertID'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,6} ->
   fun(T,V,O) -> 'PKIXCRMF-2009':'dec_regCtrl-protocolEncrKey'(T,V,O) end;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,7} ->
    fun 'dec_regCtrl-altCertTemplate'/3;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,11} ->
    fun 'dec_regCtrl-algId'/3;
getdec_ExpandedRegControlSet(Id) when Id =:= {1,3,6,1,5,5,7,5,1,12} ->
    fun 'dec_regCtrl-rsaKeyLen'/3;
getdec_ExpandedRegControlSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SupportedInfoSet
%%================================
getenc_SupportedInfoSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SupportedInfoSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_8
%%================================
getenc_internal_object_set_argument_8(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_8(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_18
%%================================
getenc_internal_object_set_argument_18(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_18(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_16
%%================================
getenc_internal_object_set_argument_16(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_16(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_14
%%================================
getenc_internal_object_set_argument_14(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_14(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_12
%%================================
getenc_internal_object_set_argument_12(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_12(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_10
%%================================
getenc_internal_object_set_argument_10(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_10(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_29
%%================================
getenc_internal_object_set_argument_29(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_29(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_27
%%================================
getenc_internal_object_set_argument_27(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_27(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_25
%%================================
getenc_internal_object_set_argument_25(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_25(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_24
%%================================
getenc_internal_object_set_argument_24(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_24(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_22
%%================================
getenc_internal_object_set_argument_22(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_22(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_20
%%================================
getenc_internal_object_set_argument_20(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_20(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Def) when Def =:= false ->
true;
is_default_1(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_bitstring2(1, Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7, B6, B5, B4, B3, B2, B1, B0], 8 - Unused);
decode_bitstring2(Len, Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7, B6, B5, B4, B3, B2, B1, B0 |
     decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B | BitList],
                     [{Name, No} | NamedNumberList],
                     No, Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList, NamedNumberList,
                                 No + 1,
                                 [Name | Result])
    end;
decode_bitstring_NNL([1 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList,
                         No + 1,
                         [{bit, No} | Result]);
decode_bitstring_NNL([0 | BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

do_encode_named_bit_string([FirstVal | RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal | RestVal], NamedBitList, []),
    Size = lists:max(ToSetPos) + 1,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len, Unused, OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused | OctetList], Len + 1).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused, Octet} = unused_bitlist(Val, 7, 0),
    {1, Unused, [Octet]}.

encode_bitstring([B8, B7, B6, B5, B4, B3, B2, B1 | Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack, Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len, 0, Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused, Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1, Unused, [Ack, Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_named_bit_string([H | _] = Bits, NamedBitList, TagIn)
    when is_atom(H) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([{bit, _} | _] = Bits, NamedBitList, TagIn) ->
    do_encode_named_bit_string(Bits, NamedBitList, TagIn);
encode_named_bit_string([], _NamedBitList, TagIn) ->
    encode_unnamed_bit_string(<<>>, TagIn);
encode_named_bit_string(Bits, _NamedBitList, TagIn)
    when is_bitstring(Bits) ->
    encode_unnamed_bit_string(Bits, TagIn).

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

get_all_bitposes([{bit, ValPos} | Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
get_all_bitposes([Val | Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName, ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos | Ack]);
        _ ->
            exit({error, {asn1, {bitstring_namedbit, Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error, {asn1, bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos | SetPos], XPos) ->
    [1 | make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos | SetPos], XPos) ->
    [0 | make_and_set_list(Len - 1, [Pos | SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0 | make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

unused_bitlist([], Trail, Ack) ->
    {Trail + 1, Ack};
unused_bitlist([Bit | Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
