/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.Objects;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public final class FilteringDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final DependencyVisitor visitor;
    private final Stack<Boolean> accepts;
    private final Stack<DependencyNode> parents;

    public FilteringDependencyVisitor(DependencyVisitor visitor, DependencyFilter filter2) {
        this.visitor = Objects.requireNonNull(visitor, "dependency visitor delegate cannot be null");
        this.filter = filter2;
        this.accepts = new Stack();
        this.parents = new Stack();
    }

    public DependencyVisitor getVisitor() {
        return this.visitor;
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean visitEnter(DependencyNode node2) {
        boolean accept2 = this.filter == null || this.filter.accept(node2, this.parents);
        this.accepts.push(accept2);
        this.parents.push(node2);
        if (accept2) {
            return this.visitor.visitEnter(node2);
        }
        return true;
    }

    @Override
    public boolean visitLeave(DependencyNode node2) {
        this.parents.pop();
        Boolean accept2 = this.accepts.pop();
        if (accept2.booleanValue()) {
            return this.visitor.visitLeave(node2);
        }
        return true;
    }
}

