const fetch = require("node-fetch");

function mergeDeep(...objects) {
  const isObject = obj => obj && typeof obj === 'object';

  return objects.reduce((prev, obj) => {
    Object.keys(obj).forEach(key => {
      const pVal = prev[key];
      const oVal = obj[key];

      if (Array.isArray(pVal) && Array.isArray(oVal)) {
        prev[key] = pVal.concat(...oVal);
      }
      else if (isObject(pVal) && isObject(oVal)) {
        prev[key] = mergeDeep(pVal, oVal);
      }
      else {
        prev[key] = oVal;
      }
    });

    return prev;
  }, {});
}

function generateId(x) {
    if(!x) { x = 10 };
    var t = "";
    var p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < x; i++) {
        t += p.charAt(Math.floor(Math.random() * p.length));
    }
    return t;
}

async function fetchGet(url, params) {
    const urlObj = new URL(url);
    urlObj.search = new URLSearchParams(params);

    const response = await fetch(urlObj, {
        method: 'GET',
        headers: {
            'Content-Type': 'application/json'
        }
    });
    return response.json();
}

async function fetchPost(url, body) {
    const response = await fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(body)
    });
    return response.json();
}

function validateIntValue(value) {
    const newValue = !isNaN(parseInt(value)) ? parseInt(value) : null;
    return newValue;
}

function arrayContains(query, theArray) {
    var foundQuery = false;
    theArray.forEach((value) => {
        if(value.indexOf(query) > -1) foundQuery = true;
    });
    return foundQuery;
}

function copyObject(obj) {
    return Object.assign({}, obj);
}

function stringContains(find, string, toLowerCase) {
    var newString = string + '';
    if (toLowerCase) newString = newString.toLowerCase();
    return newString.indexOf(find) > -1;
}

function stringToSqlTime(value) {
    const newValue = new Date(value.replace('T', ' '));
    return newValue;
}

function queryStringToObject(string) {
    const newObject = {};
    string.split('&').forEach((piece) => {
        const parts = piece.split('=');
        const key = parts[0];
        const value = parts[1];
        newObject[key] = value;
    });
    return newObject;
}

function createQueryStringFromObject(theObject) {
    const string = [];
    const keys = Object.keys(theObject);
    keys.forEach((key) => {
        const value = theObject[key];
        if (value) string.push(`${key}=${value}`);
    });
    return string.join('&');
}

module.exports = {
    fetchGet,
    fetchPost,
    generateId,
    mergeDeep,
    validateIntValue,
    arrayContains,
    copyObject,
    stringContains,
    stringToSqlTime,
    queryStringToObject,
    createQueryStringFromObject
};
